{smcl}
{* *! version 1.0.0 5aug2014}{...}
{title:Title}

{phang}
{bf:dsimih use} -- load dynamic simulation results generated by {cmd:dsimih create} into Stata data set memory


{marker syntax}{...}
{title:Syntax}

{p 8 17 2}
{cmd:dsimih use} [{it:filename}] [{cmd:,} {opt noci} {opt se} {opt l:evel(#)} {opt clear}]

{synoptset 20 tabbed}{...}
{synopthdr}
{synoptline}
{syntab:    }
{synopt: {opt noci}}do not create variables for upper and lower confidence bounds{p_end}
{synopt: {opt se}}create variables that contain standard errors of {cmd:dsimih} {it:stats} {p_end}
{synopt:{opt set:ypes(selist)}}create variables for standard errors and confidence intervals based on standard errors of type(s) {it:selist} only; default: all {it:setypes}{p_end}
{synopt:{opt l:evel(#)}}set confidence level{p_end}
{synopt:{opt clear}}specifies that it is okay to replace the data in memory, even though the current data have not been saved to disk{p_end}
{synopt:{opt n:umber(#)}}access results number {it:#} ; only allowed if the {cmd:using} modifier refers to a {cmd:.ster} file{p_end}
{synoptline}
{p2colreset}{...}


{marker description}{...}
{title:Description}

{pstd}
{cmd:dsimih use} retrieves dynamic simulation results generated by {cmd:dsimih create} into Stata data set memory.
Results can be pulled from {cmd:e()}, from a {help estimates save:.ster file}, or from a {help dsimih_etodta##dsimihfiles:dsimih file}.


{marker abbreviations}{...}
{title:Abbreviations, definitions, notation, syntax elements}

{pstd}
This help entry uses terminology defined in {help svarih##abbreviations:svarih} and {help dsimih##abbreviations:dsimih}.


{marker options}{...}
{title:Options}

{phang}
{cmd:noci} prevents {cmd:dsimih use} from creating variables that contain lower and upper confidence bounds at level #.
By default, these variables are created based on asymptotic and for (parametric and residual) bootstrapped standard errors, which makes a total of six variables per {it:stat}.
If e(dsimih) does not contain numbers for a particular type of standard error, the confidence interval variables are still created by {cmd:dsimih use}, with all values set to missing.

{phang}
{cmd:se} causes {cmd:dsimih use} to create variables that contain standard errors for SIRFs and SFEVDs.
Series are created for asymptotic and for (parametric and residual) bootstrapped standard errors, which makes a total of three variables created for each {cmd:dsimih} {it:stat}.
If e(dsimih) does not contain numbers for a particular type of standard error, the standard error variables are still created by {cmd:dsimih use}, with all values set to missing.

{phang}
{opt set:ypes(selist)} specifies the standard errors types based on which standard error variables and/or confidence band variables are created.
{it:selist} may contain individual tokens {opt a:symptotic}, {opt bs} and {opt bsp}.
They stand for asymptotic standard errors, standard errors from a residual bootstrap, and standard errors from a parametric bootstrap based on draws from the normal distribution, respectively.
Specifying multiple standard error types as in {cmd:setypes(asymp bsp)} is allowed.
The default is to create variables for all {it:setypes}.

{phang}
{opt l:evel(#)} specifies the confidence level, as a percentage, for confidence intervals, when they are reported.
The default is {cmd:level(95)} or as set by {helpb set level}.

{phang}
{opt clear} specifies that it is okay to replace the data in memory, even though the current data have not been saved to disk.


{marker remarks}{...}
{title:Remarks}

{pstd}
{cmd:dsimih use} retrieves dynamic simulation results generated by {cmd:dsimih create} into Stata data set memory.
It accesses DS results in {cmd:e()} by default but is also capable of accessing DS results stored in files using the optional {it:filename}.
For details on how the latter works, see {help dsimih_etodta##theusingmodifier:dsimih etodta}.

{pstd}
It is important to note that {cmd:dsimih use}, by default, does not load the results data as-is.
When loading {cmd:dsimih} data, {cmd:dsimih use} uses the variables that contain information on the different types of standard errors to construct variables that contain upper and lower confidence bounds for the {cmd:dsimih} {it:stat}s 'sirf' and 'sfevd'.
Then, by default, {cmd:dsimih use} drops all standard error variables.

{pstd}
Moreover, since variables 'impulse' and 'response' are stored under a numeric encoding in {cmd:e()}, {cmd:dsimih use} converts those variables to appropriate string variables.
This is not necessary if you load a {cmd:dsimih file} since it already contains variables 'impulse' and 'response' as string variables.

{pstd}
It is imperative to note that, due to the default loading actions just mentioned, the data set that you see when typing {help browse} after 

{pmore}
{cmd:. dsimih use}

{pstd}
is different from what is actually stored in {cmd:e()} or in {it:filename}.
If you want to see the exact contents of {cmd:e()} or of {it:filename}, type

{pmore}
{input:. dsimih use [{it:filename}] , se noci}


{marker examples}{...}
{title:Examples}

{pstd}
Excecuting the following statements will change current {cmd:e()}-results.

{pstd}
Bootstrap replication numbers are set to values that are inappropriate for analysis but appropriate for quick execution of example statements.

{pstd}
Generate example estimates (see {help svarih examples}):

{phang2}{stata webuse lutkepohl2:. webuse lutkepohl2}{p_end}
{phang2}{stata svarih examples bfa_constr , ereplace:. svarih examples bfa_constr , ereplace}{p_end}
{phang2}{stata dsimih describe , modelstats cmdline:. dsimih describe , modelstats cmdline}{p_end}

{phang2}{stata dsimih create:. dsimih create}{p_end}
{phang2}{stata "version 11.2: set seed 123456":. version 11.2: set seed 123456}{p_end}
{phang2}{stata dsimih create , step(12) bs fromb reps(10):. dsimih create , step(12) bs fromb reps(10)}{p_end}

{pstd}
Pull DS results from {cmd:e()} into data set memory:

{phang2}{stata dsimih use , clear:. dsimih use , clear}{p_end}
{phang2}{stata describe:. describe}{p_end}

{pstd}
Customize on {it:setype} and confidence level:

{phang2}{stata dsimih use , setype(asy bs) level(68):. dsimih use , setype(asy bs) level(68)}{p_end}
{phang2}{stata describe:. describe}{p_end}

{pstd}
To get the data that is actually stored, use options {opt se} and {opt noci}.

{phang2}{stata dsimih use , se noci:. dsimih use , se noci}{p_end}
{phang2}{stata describe:. describe}{p_end}

{pstd}
Data can also be pulled from saved {opt .ster} files.

{phang2}{stata drop _all:. drop _all}{p_end}
{phang2}{stata estimates save dsimih_examplefile , replace:. estimates save dsimih_examplefile , replace}{p_end}
{phang2}{stata dsimih use dsimih_examplefile.ster , setype(bs):. dsimih use dsimih_examplefile.ster , setype(bs)}{p_end}
{phang2}{stata describe:. describe}{p_end}

{pstd}
It is also possible to retrieve data from {help dsimih_etodta##dsimihfiles:dsimih files} created by {help dsimih etodta}.

{phang2}{stata drop _all:. drop _all}{p_end}
{phang2}{stata dsimih etodta dsimih_examplefile2.dsimih , replace:. dsimih etodta dsimih_examplefile2.dsimih , replace}{p_end}

{pstd}
These are the variables that are actually stored in the file:

{phang2}{stata describe using dsimih_examplefile2.dsimih:. describe using dsimih_examplefile2.dsimih}{p_end}

{pstd}
These are the variables in memory when the data is loaded without any options

{phang2}{stata dsimih use dsimih_examplefile2.dsimih:. dsimih use dsimih_examplefile2.dsimih}{p_end}
{phang2}{stata describe:. describe}{p_end}

{phang2}{stata erase dsimih_examplefile.ster:. erase dsimih_examplefile.ster}{p_end}
{phang2}{stata erase dsimih_examplefile2.dsimih:. erase dsimih_examplefile2.dsimih}{p_end}


{marker author}{...}
{title:Author}

{phang}
Daniel C. Schneider, Goethe University Frankfurt, dan_schneider@outlook.com


{marker alsosee}{...}
{title:Also see}

{psee}
Help:
{helpb irf:[TS] irf},
{helpb dsimih},
{helpb dsimih create},
{helpb dsimih table},
{helpb dsimih graph},
{helpb dsimih describe},
{helpb dsimih drop},
{helpb dsimih etodta}
{p_end}

